// priority: 7
// 使用方法:
// 1. 游戏内信标等级发生变化时，会自动调整对应区域的区块强加载状态。
//    - 信标等级与强加载半径的对应关系可在 "等级转半径" 函数中修改。
//    - 默认: 等级1->半径0 (1x1), 等级2->半径1 (3x3), 等级0->不加载。
// 2. 当信标被破坏时，其之前贡献的强加载会自动解除。
// 3. 区块的强加载采用引用计数方式。
// 4. 只有当信标的有效加载范围实际发生改变时，才会执行区块加载/卸载和发送通知/粒子。
// 5. 当强加载范围发生变化时，会显示粒子效果。
//    - 粒子类型、持续时间、密度等可在 "生成边界粒子" 函数中修改。

let 区块强加载计数据 = "KJS_区块加载器计数";
let 活动信标加载器数据 = "KJS_信标加载器状态"; 
let 获取维度 = (维度) => String(维度.dimension);
let 更新区块强加载状态 = (维度, 区块X坐标, 区块Z坐标, 请求加载, s) => {
    let 维度ID = 获取维度(维度);
    let 区块唯一标识 = `${维度ID}:${区块X坐标},${区块Z坐标}`;
    let 区块计数总览 = JSON.parse(s.persistentData.getString(区块强加载计数据) || "{}");
    let 当前计数 = 区块计数总览[区块唯一标识] || 0;
    let 旧计数 = 当前计数;
    if (请求加载) {
        当前计数++; 区块计数总览[区块唯一标识] = 当前计数;
        if (旧计数 === 0 && 当前计数 === 1) { 维度.setChunkForced(区块X坐标, 区块Z坐标, true); } 
    } else { 
        if (当前计数 > 0) { 当前计数--; }
        if (当前计数 === 0) {
            delete 区块计数总览[区块唯一标识];
            if (旧计数 > 0) { 维度.setChunkForced(区块X坐标, 区块Z坐标, false); } 
        } else { 区块计数总览[区块唯一标识] = 当前计数; }
    }
    s.persistentData.putString(区块强加载计数据, JSON.stringify(区块计数总览));
};

let 等级转半径 = (LV) => {
    // 使用方法: 修改此函数的返回值可以改变信标等级与强加载半径的对应关系。
    if (LV <= 0) return -1;
    return LV - 1;
};

let 生成边界粒子 = (世界参数, 半径显示, 中心X坐标, 中心Z坐标, 激活参数) => {
    if (半径显示 < 0 && 激活参数) return;
    if (半径显示 < 0 && !激活参数) {} else if (半径显示 < 0) return;
    let 区域最小X = (中心X坐标 - 半径显示) * 16;
    let 区域最大X = (中心X坐标 + 半径显示 + 1) * 16 - 1; 
    let 区域最小Z = (中心Z坐标 - 半径显示) * 16;
    let 区域最大Z = (中心Z坐标 + 半径显示 + 1) * 16 - 1;
    let 激活粒子ID = "minecraft:happy_villager";
    let 解除粒子ID = "minecraft:smoke";
    let 粒子效果ID = 激活参数 ? 激活粒子ID : 解除粒子ID;
    let 粒子总批次数 = 20; 
    let 每批间隔刻数 = 10; 
    let 每批每个点粒子数 = 20; 
    let 粒子Y轴随机范围 = 10; 
    let 粒子Y轴扩散 = 5;    
    let 粒子扩散 = 0.5; 
    let 粒子速度 = 0.01;

    for (let 序号 = 0; 序号 < 粒子总批次数; 序号++) {
        Utils.server.scheduleInTicks(序号 * 每批间隔刻数, () => {
            let 目标点列表 = [ 
                { x: 区域最小X, z: 区域最小Z },{ x: 区域最大X, z: 区域最小Z },
                { x: 区域最小X, z: 区域最大Z },{ x: 区域最大X, z: 区域最大Z }
            ];
            let 标准维度标识符 = 获取维度(世界参数);
            let 当前世界用于粒子 = Utils.server.getLevel(标准维度标识符);
            if (!当前世界用于粒子) return;
            for (let 点坐标 of 目标点列表) {
                let 地面Y坐标 = 当前世界用于粒子.getHeight($高度图类型.MOTION_BLOCKING_NO_LEAVES, 点坐标.x, 点坐标.z);
                let 粒子Y坐标 = 地面Y坐标 + Math.random() * 粒子Y轴随机范围; 
                let 粒子命令 = `/particle ${粒子效果ID} ${点坐标.x} ${粒子Y坐标} ${点坐标.z} ${粒子扩散} ${粒子Y轴扩散} ${粒子扩散} ${粒子速度} ${每批每个点粒子数} normal`;
                Utils.server.runCommandSilent(粒子命令);
            }
        });
    }
};

BeaconEvent.levelChanged(e => {
    let 维度 = e.getLevel();
    let 旧等级 = e.getOldLevel();
    let 新等级 = e.getNewLevel();
    let 信标坐标 = e.getBlockPos();
    let s = Utils.server; 
    if (旧等级 === 新等级) return;
    let 信标X = Math.floor(信标坐标.x / 16);
    let 信标Z = Math.floor(信标坐标.z / 16);
    let 计算的新半径 = 等级转半径(新等级);
    let 维度ID = 获取维度(维度);
    let 信标唯一ID = `${维度ID}:${信标坐标.x},${信标坐标.y},${信标坐标.z}`;
    let 活动信标表 = JSON.parse(s.persistentData.getString(活动信标加载器数据) || "{}");
    let 存储的半径 = 活动信标表[信标唯一ID];
    if (存储的半径 === undefined) 存储的半径 = -1; 

    if (计算的新半径 === 存储的半径) {
        if (计算的新半径 >= 0) {
            if (活动信标表[信标唯一ID] !== 计算的新半径) { 
                 活动信标表[信标唯一ID] = 计算的新半径;
                 s.persistentData.putString(活动信标加载器数据, JSON.stringify(活动信标表));
            }
        } else { 
            if (活动信标表.hasOwnProperty(信标唯一ID)) {
                delete 活动信标表[信标唯一ID];
                s.persistentData.putString(活动信标加载器数据, JSON.stringify(活动信标表));
            }
        }
        return;
    }
    
    let 旧半径 = 存储的半径;
    let 新半径 = 计算的新半径; 

    let 扫描半径 = Math.max(旧半径, 新半径);
    if (扫描半径 >= 0) { 
        for (let X偏移 = -扫描半径; X偏移 <= 扫描半径; X偏移++) {
            for (let Z偏移 = -扫描半径; Z偏移 <= 扫描半径; Z偏移++) {
                let 区块X = 信标X + X偏移;
                let 区块Z = 信标Z + Z偏移;
                let 在操作旧半径内 = (旧半径 >= 0 && Math.abs(X偏移) <= 旧半径 && Math.abs(Z偏移) <= 旧半径);
                let 在操作新半径内 = (新半径 >= 0 && Math.abs(X偏移) <= 新半径 && Math.abs(Z偏移) <= 新半径);

                if (在操作旧半径内 && !在操作新半径内) { 
                    更新区块强加载状态(维度, 区块X, 区块Z, false, s);
                } else if (!在操作旧半径内 && 在操作新半径内) { 
                    更新区块强加载状态(维度, 区块X, 区块Z, true, s);
                }
            }
        }
    }
    
    if (新半径 >= 0) {
        活动信标表[信标唯一ID] = 新半径;
    } else {
        delete 活动信标表[信标唯一ID]; 
    }
    s.persistentData.putString(活动信标加载器数据, JSON.stringify(活动信标表));
    
    let 维度名称 = 维度ID.includes(":") ? 维度ID.substring(维度ID.indexOf(":") + 1) : 维度ID;
    let x = 信标坐标.x; let y = 信标坐标.y; let z = 信标坐标.z;
    let 提示文本 = null;
    let 粒子效果 = false;
    let 粒子激活 = false;
    let 粒子半径 = -1;

    if (新半径 >= 0) { 
        let 范围显示 = `${2 * 新半径 + 1}x${2 * 新半径 + 1}`;
        提示文本 = Text.gold("[强加载] ").append(Text.white(`位于 ${x},${y},${z} (${维度名称}) 范围已更新为 `)).append(Text.aqua(范围显示)).append(Text.white("。"));
        粒子效果 = true;
        粒子激活 = true;
        粒子半径 = 新半径;
    } else if (旧半径 >= 0 && 新半径 < 0) { 
        提示文本 = Text.gold("[强加载] ").append(Text.white(`位于 ${x},${y},${z} (${维度名称}) 已解除其区域强加载。`));
        粒子效果 = true;
        粒子激活 = false;
        粒子半径 = 旧半径; 
    }

    if (粒子效果 && 粒子半径 >=0) {
         生成边界粒子(维度, 粒子半径, 信标X, 信标Z, 粒子激活);
    }
    if (提示文本 && 维度.players) { 
        let 通知检测半径 = 64; 
        let 通知检测半径平方 = 通知检测半径 * 通知检测半径;
        维度.players.forEach(单个玩家 => {
            let X方向距离 = 单个玩家.x - x;
            let Y方向距离 = 单个玩家.y - y;
            let Z方向距离 = 单个玩家.z - z;
            let 距离的平方 = X方向距离*X方向距离 + Y方向距离*Y方向距离 + Z方向距离*Z方向距离;
            if (距离的平方 < 通知检测半径平方) {
                单个玩家.tell(提示文本);
            }
        });
    }
});

BlockEvents.broken("minecraft:beacon", e => {
    let 维度 = e.level;
    let 信标坐标 = e.block.pos; 
    let s = Utils.server;
    let 维度ID = 获取维度(维度);
    let 信标唯一ID = `${维度ID}:${信标坐标.x},${信标坐标.y},${信标坐标.z}`;
    let 信标X = Math.floor(信标坐标.x / 16);
    let 信标Z = Math.floor(信标坐标.z / 16);

    let 活动信标表 = JSON.parse(s.persistentData.getString(活动信标加载器数据) || "{}");
    let 被破坏信标旧半径 = 活动信标表[信标唯一ID];

    if (被破坏信标旧半径 !== undefined && 被破坏信标旧半径 >= 0) {
        for (let X偏移 = -被破坏信标旧半径; X偏移 <= 被破坏信标旧半径; X偏移++) {
            for (let Z偏移 = -被破坏信标旧半径; Z偏移 <= 被破坏信标旧半径; Z偏移++) {
                更新区块强加载状态(维度, 信标X + X偏移, 信标Z + Z偏移, false, s);
            }
        }
        生成边界粒子(维度, 被破坏信标旧半径, 信标X, 信标Z, false); 
        
        let 维度名称 = 维度ID.includes(":") ? 维度ID.substring(维度ID.indexOf(":") + 1) : 维度ID;
        let x = 信标坐标.x; let y = 信标坐标.y; let z = 信标坐标.z;
        let 提示文本 = Text.gold("[信标] ").append(Text.white(`位于 ${x},${y},${z} (${维度名称}) 的信标被破坏，其区域强加载已解除。`));
        if (维度.players) {
            let 通知检测半径 = 64; let 通知检测半径平方 = 通知检测半径 * 通知检测半径;
            维度.players.forEach(单个玩家 => {
                let X方向距离 = 单个玩家.x - x;
                let Y方向距离 = 单个玩家.y - y;
                let Z方向距离 = 单个玩家.z - z;
                let 距离的平方 = X方向距离*X方向距离 + Y方向距离*Y方向距离 + Z方向距离*Z方向距离;
                if (距离的平方 < 通知检测半径平方) {
                    单个玩家.tell(提示文本);
                }
            });
        }
    }
    delete 活动信标表[信标唯一ID]; 
    s.persistentData.putString(活动信标加载器数据, JSON.stringify(活动信标表));
});